<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<div class="container py-5">
    <div class="text-center mb-5">
        <i class="fas fa-heart fa-4x text-primary mb-3"></i>
        <h2 class="fw-bold">Your Support Makes a Difference</h2>
        <p class="lead text-muted">Every contribution helps us create lasting change</p>
    </div>
    
    <div class="row mb-5">
        <div class="col-md-3 col-6 mb-3 text-center">
            <div class="p-3 bg-light rounded">
                <h3 class="fw-bold text-primary"><?php echo number_format($impact_stats['lives_impacted'] ?? 0); ?>+</h3>
                <p class="mb-0">Lives Impacted</p>
            </div>
        </div>
        <div class="col-md-3 col-6 mb-3 text-center">
            <div class="p-3 bg-light rounded">
                <h3 class="fw-bold text-primary"><?php echo number_format($impact_stats['workshops_held'] ?? 0); ?>+</h3>
                <p class="mb-0">Workshops Held</p>
            </div>
        </div>
        <div class="col-md-3 col-6 mb-3 text-center">
            <div class="p-3 bg-light rounded">
                <h3 class="fw-bold text-primary"><?php echo number_format($impact_stats['active_volunteers'] ?? 0); ?>+</h3>
                <p class="mb-0">Volunteers</p>
            </div>
        </div>
        <div class="col-md-3 col-6 mb-3 text-center">
            <div class="p-3 bg-light rounded">
                <h3 class="fw-bold text-primary"><?php echo number_format($impact_stats['partners'] ?? 0); ?>+</h3>
                <p class="mb-0">Partners</p>
            </div>
        </div>
    </div>
    
    <div class="row">
        <div class="col-lg-8 mb-4">
            <div class="card shadow border-0">
                <div class="card-body p-4 p-md-5">
                    <h3 class="fw-bold mb-4">Bank Transfer Details</h3>
                    
                    <div class="mb-4">
                        <label class="fw-bold d-block mb-2">Bank Name:</label>
                        <p class="fs-5"><?php echo htmlspecialchars($donation_details['bank_name']); ?></p>
                    </div>
                    
                    <div class="mb-4">
                        <label class="fw-bold d-block mb-2">Account Number:</label>
                        <p class="fs-5"><?php echo htmlspecialchars($donation_details['account_number']); ?></p>
                    </div>
                    
                    <div class="mb-4">
                        <label class="fw-bold d-block mb-2">Account Name:</label>
                        <p class="fs-5"><?php echo htmlspecialchars($donation_details['account_name']); ?></p>
                    </div>
                    
                    <hr class="my-4">
                    
                    <h5 class="fw-bold mb-3">Mobile Money</h5>
                    <p class="fs-5"><?php echo htmlspecialchars($donation_details['mobile_money']); ?></p>
                    
                    <div class="alert alert-info mt-4">
                        <i class="fas fa-info-circle"></i>
                        <strong>Note:</strong> Please send us an email or WhatsApp message after making your donation so we can acknowledge your contribution.
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-lg-4">
            <div class="card shadow border-0 mb-4" style="background: linear-gradient(135deg, #f26124, #8105bf);">
                <div class="card-body p-4 text-white text-center">
                    <h5 class="fw-bold mb-3">Other Ways to Help</h5>
                    <p class="mb-3">Your time and skills are valuable too!</p>
                    <a href="<?php echo base_url('volunteer/apply'); ?>" class="btn btn-light w-100 mb-2">
                        <i class="fas fa-hands-helping"></i> Volunteer
                    </a>
                    <a href="<?php echo base_url('contact'); ?>" class="btn btn-outline-light w-100">
                        <i class="fas fa-handshake"></i> Partner With Us
                    </a>
                </div>
            </div>
            
            <div class="card shadow border-0">
                <div class="card-body p-4">
                    <h5 class="fw-bold mb-3">Contact Us</h5>
                    <p class="small">Have questions about donations? Get in touch!</p>
                    <a href="<?php echo base_url('contact'); ?>" class="btn btn-outline-primary w-100">
                        <i class="fas fa-envelope"></i> Contact Us
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>